/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.atm.eui;

import ibm.nways.atm.model.AtmInterfaceModel;
import ibm.nways.jdm.DestinationPropBook;
import ibm.nways.jdm.JmaColors;
import ibm.nways.jdm.NavFieldOverride;
import ibm.nways.jdm.NavInitialRow;
import ibm.nways.jdm.NavigationContext;
import ibm.nways.jdm.RemoteModelWithStatus;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.eui.EuiGrid;
import ibm.nways.jdm.eui.EuiGridEvent;
import ibm.nways.jdm.eui.EuiGridListener;
import ibm.nways.jdm.eui.JDMInput;
import ibm.nways.jdm.eui.NumericInput;
import ibm.nways.jdm.eui.PropertySection;
import ibm.nways.jdm.eui.SingleChoiceInput;
import ibm.nways.jdm.eui.SingleChoiceInputRO;
import ibm.nways.jdm.eui.StringInput;
import ibm.nways.jdm.eui.StringInputRO;
import ibm.nways.jdm.eui.Table;
import ibm.nways.jdm.eui.TableColumn;
import ibm.nways.jdm.eui.TableColumns;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.jdm.modelgen.TableStatus;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;

public class AtmInterfacePanel
extends DestinationPropBook {
    protected static ResourceBundle enumStrings = null;
    protected static ResourceBundle myResources = null;
    private static String title = "Interface";
    protected boolean containsWritableField = false;
    protected boolean containsCreatableField = false;
    protected GenModel AtmInterface_model;
    protected selectionListSection selectionListPropertySection;
    protected atmInterfaceConfDetailSection atmInterfaceConfDetailPropertySection;
    protected ModelInfo AtmInterfaceConfTableInfo;
    protected ModelInfo PanelInfo;
    protected int AtmInterfaceConfTableIndex;
    protected AtmInterfaceConfTable AtmInterfaceConfTableData;
    protected TableColumns AtmInterfaceConfTableColumns;
    protected TableStatus AtmInterfaceConfTableStatus;
    protected static TableColumn[] AtmInterfaceConfTableCols = new TableColumn[]{new TableColumn("Index.IfIndex", "Interface", 3, true), new TableColumn("Panel.IfDescr", "Description", 5, false)};
    protected boolean errorsFound = false;

    private static void loadStatics() {
        try {
            if (enumStrings == null) {
                enumStrings = ResourceBundle.getBundle("ibm.nways.atm.eui.EnumeratedResources");
            }
            if (myResources == null) {
                myResources = ResourceBundle.getBundle("ibm.nways.atm.eui.AtmInterfacePanelResources");
                return;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Unable to access translation resources for panel AtmInterface");
        }
    }

    public static String getTitle() {
        AtmInterfacePanel.loadStatics();
        if (myResources != null) {
            title = AtmInterfacePanel.getNLSString("AtmInterfacePanelTitle");
        }
        return title;
    }

    private static ResourceBundle getEnumStrings() {
        if (enumStrings == null) {
            AtmInterfacePanel.loadStatics();
        }
        return enumStrings;
    }

    public AtmInterfacePanel() {
        AtmInterfacePanel.loadStatics();
    }

    public Insets getInsets() {
        return new Insets(3, 3, 3, 3);
    }

    public String getDestinationTitle() {
        return AtmInterfacePanel.getTitle();
    }

    protected void getModels() {
        this.AtmInterface_model = (GenModel)this.getModel();
    }

    public void addSections() {
        this.getModels();
        this.createTables();
        this.addselectionListSection();
        this.addatmInterfaceConfDetailSection();
        if (this.containsCreatableField) {
            this.addCreateButton();
        }
        if (this.containsWritableField) {
            this.addApplyButton();
        }
        this.addRefreshButton();
        this.addHelpButton();
        this.reset();
    }

    protected void addselectionListSection() {
        this.selectionListPropertySection = new selectionListSection();
        this.selectionListPropertySection.layoutSection();
        this.addSection(AtmInterfacePanel.getNLSString("selectionListSectionTitle"), this.selectionListPropertySection);
    }

    protected void addatmInterfaceConfDetailSection() {
        this.atmInterfaceConfDetailPropertySection = new atmInterfaceConfDetailSection();
        this.atmInterfaceConfDetailPropertySection.layoutSection();
        this.addSection(AtmInterfacePanel.getNLSString("atmInterfaceConfDetailSectionTitle"), this.atmInterfaceConfDetailPropertySection);
    }

    protected void panelRowChange() {
        if (this.selectionListPropertySection != null) {
            this.selectionListPropertySection.rowChange();
        }
        if (this.atmInterfaceConfDetailPropertySection != null) {
            this.atmInterfaceConfDetailPropertySection.rowChange();
        }
    }

    public void filterPanelInfos(Vector vector) {
    }

    public int getInitialAtmInterfaceConfTableRow() {
        return 0;
    }

    public ModelInfo initialAtmInterfaceConfTableRow() {
        ModelInfo modelInfo = null;
        if (this.getNavContext() instanceof NavigationContext) {
            modelInfo = NavInitialRow.getInitialRow(this.getNavContext(), true);
        }
        return modelInfo;
    }

    protected void displayMsg(String string) {
        if (this.getBrowser() != null) {
            this.getBrowser().displayMsg(string);
        }
    }

    protected static String getNLSString(String string) {
        if (myResources == null) {
            return string;
        }
        try {
            return myResources.getString(string);
        }
        catch (Exception exception) {
            return string;
        }
    }

    protected String getOverride(String string, String string2) {
        String string3 = null;
        try {
            string3 = NavFieldOverride.getFieldOverride(this.getNavContext(), string);
        }
        catch (ClassCastException classCastException) {
        }
        catch (MissingResourceException missingResourceException) {
        }
        catch (NullPointerException nullPointerException) {}
        if (string3 == null) {
            string3 = string2;
        }
        return string3;
    }

    public void reset() {
        this.displayMsg(AtmInterfacePanel.getNLSString("startResetMsg"));
        this.AtmInterfaceConfTableData.invalidate();
        this.errorsFound = false;
        super.reset();
        if (!this.errorsFound) {
            this.displayMsg(AtmInterfacePanel.getNLSString("endResetMsg"));
            return;
        }
        this.displayMsg(String.valueOf(AtmInterfacePanel.getNLSString("endResetMsg")) + " " + AtmInterfacePanel.getNLSString("noteErrorsMsg"));
    }

    public void apply() {
        this.PanelInfo = new ModelInfo();
        this.PanelInfo.add("Index.IfIndex", (Serializable)this.AtmInterfaceConfTableData.getValueAt("Index.IfIndex", this.AtmInterfaceConfTableIndex));
        this.errorsFound = false;
        this.displayMsg(AtmInterfacePanel.getNLSString("startApplyMsg"));
        super.apply();
        if (!this.errorsFound) {
            this.AtmInterfaceConfTableInfo = (ModelInfo)this.AtmInterfaceConfTableData.elementAt(this.AtmInterfaceConfTableIndex);
            this.AtmInterfaceConfTableInfo = this.AtmInterfaceConfTableData.setRow();
            this.AtmInterfaceConfTableData.setElementAt(this.AtmInterfaceConfTableInfo, this.AtmInterfaceConfTableIndex);
            super.reset();
            if (!this.errorsFound) {
                this.displayMsg(AtmInterfacePanel.getNLSString("endApplyMsg"));
                return;
            }
            this.displayMsg(String.valueOf(AtmInterfacePanel.getNLSString("endApplyMsg")) + " " + AtmInterfacePanel.getNLSString("noteErrorsMsg"));
            return;
        }
        this.displayMsg(AtmInterfacePanel.getNLSString("abortApplyMsg"));
    }

    public void createTables() {
        this.AtmInterfaceConfTableData = new AtmInterfaceConfTable();
        this.AtmInterfaceConfTableIndex = 0;
        this.AtmInterfaceConfTableColumns = new TableColumns(AtmInterfaceConfTableCols);
        if (this.AtmInterface_model instanceof RemoteModelWithStatus) {
            try {
                this.AtmInterfaceConfTableStatus = (TableStatus)this.AtmInterface_model.getStatus();
                return;
            }
            catch (RemoteException remoteException) {
                System.out.println(remoteException);
                remoteException.printStackTrace();
                return;
            }
        }
    }

    public class selectionListSection
    extends PropertySection
    implements EuiGridListener {
        ModelInfo chunk;
        Component AtmInterfaceConfTableField;
        Label AtmInterfaceConfTableFieldLabel;
        boolean AtmInterfaceConfTableFieldWritable = false;

        public selectionListSection() {
            AtmInterfacePanel.this = AtmInterfacePanel.this;
            this.setLayout(new GridBagLayout());
            this.setInsets(new Insets(5, 5, 5, 5));
        }

        protected Component createAtmInterfaceConfTableField() {
            EuiGrid euiGrid = new EuiGrid(AtmInterfacePanel.this.AtmInterfaceConfTableData, AtmInterfacePanel.this.AtmInterfaceConfTableColumns, false);
            euiGrid.addRows(5);
            euiGrid.addEuiGridListener(this);
            euiGrid.setInitialRow(AtmInterfacePanel.this.initialAtmInterfaceConfTableRow());
            this.addTable(AtmInterfacePanel.getNLSString("AtmInterfaceConfTableLabel"), euiGrid);
            return euiGrid;
        }

        public void layoutSection() {
            this.AtmInterfaceConfTableField = this.createAtmInterfaceConfTableField();
        }

        public void apply() {
            if (!this.validateSection()) {
                AtmInterfacePanel.this.errorsFound = true;
            }
        }

        public void reset() {
            AtmInterfacePanel.this.displayMsg(AtmInterfacePanel.getNLSString("accessDataMsg"));
            AtmInterfacePanel.this.displayMsg(AtmInterfacePanel.getNLSString("startTableGetMsg"));
            ((EuiGrid)this.AtmInterfaceConfTableField).refresh();
            AtmInterfacePanel.this.displayMsg(AtmInterfacePanel.getNLSString("endTableGetMsg"));
            AtmInterfacePanel.this.errorsFound = !this.validateSection();
            this.doLayout();
        }

        protected void rowChange() {
            this.doLayout();
        }

        public boolean validateSection() {
            return true;
        }

        public void onEuiGridEvent(EuiGridEvent euiGridEvent) {
            System.out.println("Event received in section");
            if (euiGridEvent.getType() == 2001) {
                try {
                    if (euiGridEvent.getSource() == this.AtmInterfaceConfTableField) {
                        AtmInterfacePanel.this.AtmInterfaceConfTableIndex = euiGridEvent.getRow();
                    }
                    AtmInterfacePanel.this.AtmInterfaceConfTableIndex = euiGridEvent.getRow();
                    ((EuiGrid)this.AtmInterfaceConfTableField).deselectAllRows();
                    AtmInterfacePanel.this.panelRowChange();
                    return;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    EuiGrid euiGrid = (EuiGrid)euiGridEvent.getSource();
                    euiGrid.deleteAllRows();
                    if (euiGridEvent.getSource() == this.AtmInterfaceConfTableField) {
                        AtmInterfacePanel.this.AtmInterfaceConfTableIndex = 0;
                    }
                    AtmInterfacePanel.this.selectionListPropertySection.reset();
                    AtmInterfacePanel.this.atmInterfaceConfDetailPropertySection.reset();
                    return;
                }
            }
        }
    }

    public class atmInterfaceConfDetailSection
    extends PropertySection {
        ModelInfo chunk;
        Component ifDescrField;
        Component atmInterfaceMaxVpcsField;
        Component atmInterfaceMaxVccsField;
        Component atmInterfaceConfVpcsField;
        Component atmInterfaceConfVccsField;
        Component atmInterfaceMaxActiveVpiBitsField;
        Component atmInterfaceMaxActiveVciBitsField;
        Component atmInterfaceIlmiVpiField;
        Component atmInterfaceIlmiVciField;
        Component atmInterfaceAddressTypeField;
        Label ifDescrFieldLabel;
        Label atmInterfaceMaxVpcsFieldLabel;
        Label atmInterfaceMaxVccsFieldLabel;
        Label atmInterfaceConfVpcsFieldLabel;
        Label atmInterfaceConfVccsFieldLabel;
        Label atmInterfaceMaxActiveVpiBitsFieldLabel;
        Label atmInterfaceMaxActiveVciBitsFieldLabel;
        Label atmInterfaceIlmiVpiFieldLabel;
        Label atmInterfaceIlmiVciFieldLabel;
        Label atmInterfaceAddressTypeFieldLabel;
        boolean ifDescrFieldWritable = false;
        boolean atmInterfaceMaxVpcsFieldWritable = false;
        boolean atmInterfaceMaxVccsFieldWritable = false;
        boolean atmInterfaceConfVpcsFieldWritable = false;
        boolean atmInterfaceConfVccsFieldWritable = false;
        boolean atmInterfaceMaxActiveVpiBitsFieldWritable = false;
        boolean atmInterfaceMaxActiveVciBitsFieldWritable = false;
        boolean atmInterfaceIlmiVpiFieldWritable = false;
        boolean atmInterfaceIlmiVciFieldWritable = false;
        boolean atmInterfaceAddressTypeFieldWritable = false;

        public atmInterfaceConfDetailSection() {
            AtmInterfacePanel.this = AtmInterfacePanel.this;
            this.setLayout(new GridBagLayout());
            this.setInsets(new Insets(5, 5, 5, 5));
        }

        protected Component createifDescrField() {
            String string = AtmInterfacePanel.this.getOverride("ibm.nways.atm.model.AtmInterface.Panel.IfDescr.access", "read-only");
            String string2 = AtmInterfacePanel.this.getOverride("ibm.nways.atm.model.AtmInterface.Panel.IfDescr.length", "255");
            this.ifDescrFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.ifDescrFieldLabel = new Label(AtmInterfacePanel.getNLSString("ifDescrLabel"), 2);
            if (this.ifDescrFieldWritable) {
                StringInput stringInput = new StringInput();
                stringInput.setMaxLength(Integer.parseInt(string2));
                this.addRow(this.ifDescrFieldLabel, (Component)stringInput);
                AtmInterfacePanel.this.containsWritableField = true;
                return stringInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.ifDescrFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getifDescrField() {
            JDMInput jDMInput = (JDMInput)((Object)this.ifDescrField);
            this.validateifDescrField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setifDescrField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.ifDescrField);
                jDMInput.setValue(object);
                this.validateifDescrField();
            }
        }

        protected boolean validateifDescrField() {
            JDMInput jDMInput = (JDMInput)((Object)this.ifDescrField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.ifDescrFieldLabel.setForeground(Color.yellow);
            } else {
                this.ifDescrFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createatmInterfaceMaxVpcsField() {
            String string = AtmInterfacePanel.this.getOverride("ibm.nways.atm.model.AtmInterface.Panel.AtmInterfaceMaxVpcs.access", "read-write");
            this.atmInterfaceMaxVpcsFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.atmInterfaceMaxVpcsFieldLabel = new Label(AtmInterfacePanel.getNLSString("atmInterfaceMaxVpcsLabel"), 2);
            if (this.atmInterfaceMaxVpcsFieldWritable) {
                NumericInput numericInput = new NumericInput();
                numericInput.setMinMax(0, 4096);
                this.addRow(this.atmInterfaceMaxVpcsFieldLabel, (Component)numericInput);
                AtmInterfacePanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.atmInterfaceMaxVpcsFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getatmInterfaceMaxVpcsField() {
            JDMInput jDMInput = (JDMInput)((Object)this.atmInterfaceMaxVpcsField);
            this.validateatmInterfaceMaxVpcsField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setatmInterfaceMaxVpcsField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.atmInterfaceMaxVpcsField);
                jDMInput.setValue(object);
                this.validateatmInterfaceMaxVpcsField();
            }
        }

        protected boolean validateatmInterfaceMaxVpcsField() {
            JDMInput jDMInput = (JDMInput)((Object)this.atmInterfaceMaxVpcsField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.atmInterfaceMaxVpcsFieldLabel.setForeground(Color.yellow);
            } else {
                this.atmInterfaceMaxVpcsFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createatmInterfaceMaxVccsField() {
            String string = AtmInterfacePanel.this.getOverride("ibm.nways.atm.model.AtmInterface.Panel.AtmInterfaceMaxVccs.access", "read-write");
            this.atmInterfaceMaxVccsFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.atmInterfaceMaxVccsFieldLabel = new Label(AtmInterfacePanel.getNLSString("atmInterfaceMaxVccsLabel"), 2);
            if (this.atmInterfaceMaxVccsFieldWritable) {
                NumericInput numericInput = new NumericInput();
                numericInput.setMinMax(0, 65536);
                this.addRow(this.atmInterfaceMaxVccsFieldLabel, (Component)numericInput);
                AtmInterfacePanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.atmInterfaceMaxVccsFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getatmInterfaceMaxVccsField() {
            JDMInput jDMInput = (JDMInput)((Object)this.atmInterfaceMaxVccsField);
            this.validateatmInterfaceMaxVccsField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setatmInterfaceMaxVccsField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.atmInterfaceMaxVccsField);
                jDMInput.setValue(object);
                this.validateatmInterfaceMaxVccsField();
            }
        }

        protected boolean validateatmInterfaceMaxVccsField() {
            JDMInput jDMInput = (JDMInput)((Object)this.atmInterfaceMaxVccsField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.atmInterfaceMaxVccsFieldLabel.setForeground(Color.yellow);
            } else {
                this.atmInterfaceMaxVccsFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createatmInterfaceConfVpcsField() {
            String string = AtmInterfacePanel.this.getOverride("ibm.nways.atm.model.AtmInterface.Panel.AtmInterfaceConfVpcs.access", "read-only");
            this.atmInterfaceConfVpcsFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.atmInterfaceConfVpcsFieldLabel = new Label(AtmInterfacePanel.getNLSString("atmInterfaceConfVpcsLabel"), 2);
            if (this.atmInterfaceConfVpcsFieldWritable) {
                NumericInput numericInput = new NumericInput();
                numericInput.setMinMax(0, 4096);
                this.addRow(this.atmInterfaceConfVpcsFieldLabel, (Component)numericInput);
                AtmInterfacePanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.atmInterfaceConfVpcsFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getatmInterfaceConfVpcsField() {
            JDMInput jDMInput = (JDMInput)((Object)this.atmInterfaceConfVpcsField);
            this.validateatmInterfaceConfVpcsField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setatmInterfaceConfVpcsField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.atmInterfaceConfVpcsField);
                jDMInput.setValue(object);
                this.validateatmInterfaceConfVpcsField();
            }
        }

        protected boolean validateatmInterfaceConfVpcsField() {
            JDMInput jDMInput = (JDMInput)((Object)this.atmInterfaceConfVpcsField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.atmInterfaceConfVpcsFieldLabel.setForeground(Color.yellow);
            } else {
                this.atmInterfaceConfVpcsFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createatmInterfaceConfVccsField() {
            String string = AtmInterfacePanel.this.getOverride("ibm.nways.atm.model.AtmInterface.Panel.AtmInterfaceConfVccs.access", "read-only");
            this.atmInterfaceConfVccsFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.atmInterfaceConfVccsFieldLabel = new Label(AtmInterfacePanel.getNLSString("atmInterfaceConfVccsLabel"), 2);
            if (this.atmInterfaceConfVccsFieldWritable) {
                NumericInput numericInput = new NumericInput();
                numericInput.setMinMax(0, 65536);
                this.addRow(this.atmInterfaceConfVccsFieldLabel, (Component)numericInput);
                AtmInterfacePanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.atmInterfaceConfVccsFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getatmInterfaceConfVccsField() {
            JDMInput jDMInput = (JDMInput)((Object)this.atmInterfaceConfVccsField);
            this.validateatmInterfaceConfVccsField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setatmInterfaceConfVccsField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.atmInterfaceConfVccsField);
                jDMInput.setValue(object);
                this.validateatmInterfaceConfVccsField();
            }
        }

        protected boolean validateatmInterfaceConfVccsField() {
            JDMInput jDMInput = (JDMInput)((Object)this.atmInterfaceConfVccsField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.atmInterfaceConfVccsFieldLabel.setForeground(Color.yellow);
            } else {
                this.atmInterfaceConfVccsFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createatmInterfaceMaxActiveVpiBitsField() {
            String string = AtmInterfacePanel.this.getOverride("ibm.nways.atm.model.AtmInterface.Panel.AtmInterfaceMaxActiveVpiBits.access", "read-write");
            this.atmInterfaceMaxActiveVpiBitsFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.atmInterfaceMaxActiveVpiBitsFieldLabel = new Label(AtmInterfacePanel.getNLSString("atmInterfaceMaxActiveVpiBitsLabel"), 2);
            if (this.atmInterfaceMaxActiveVpiBitsFieldWritable) {
                NumericInput numericInput = new NumericInput();
                numericInput.setMinMax(0, 12);
                this.addRow(this.atmInterfaceMaxActiveVpiBitsFieldLabel, (Component)numericInput);
                AtmInterfacePanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.atmInterfaceMaxActiveVpiBitsFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getatmInterfaceMaxActiveVpiBitsField() {
            JDMInput jDMInput = (JDMInput)((Object)this.atmInterfaceMaxActiveVpiBitsField);
            this.validateatmInterfaceMaxActiveVpiBitsField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setatmInterfaceMaxActiveVpiBitsField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.atmInterfaceMaxActiveVpiBitsField);
                jDMInput.setValue(object);
                this.validateatmInterfaceMaxActiveVpiBitsField();
            }
        }

        protected boolean validateatmInterfaceMaxActiveVpiBitsField() {
            JDMInput jDMInput = (JDMInput)((Object)this.atmInterfaceMaxActiveVpiBitsField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.atmInterfaceMaxActiveVpiBitsFieldLabel.setForeground(Color.yellow);
            } else {
                this.atmInterfaceMaxActiveVpiBitsFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createatmInterfaceMaxActiveVciBitsField() {
            String string = AtmInterfacePanel.this.getOverride("ibm.nways.atm.model.AtmInterface.Panel.AtmInterfaceMaxActiveVciBits.access", "read-write");
            this.atmInterfaceMaxActiveVciBitsFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.atmInterfaceMaxActiveVciBitsFieldLabel = new Label(AtmInterfacePanel.getNLSString("atmInterfaceMaxActiveVciBitsLabel"), 2);
            if (this.atmInterfaceMaxActiveVciBitsFieldWritable) {
                NumericInput numericInput = new NumericInput();
                numericInput.setMinMax(0, 16);
                this.addRow(this.atmInterfaceMaxActiveVciBitsFieldLabel, (Component)numericInput);
                AtmInterfacePanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.atmInterfaceMaxActiveVciBitsFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getatmInterfaceMaxActiveVciBitsField() {
            JDMInput jDMInput = (JDMInput)((Object)this.atmInterfaceMaxActiveVciBitsField);
            this.validateatmInterfaceMaxActiveVciBitsField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setatmInterfaceMaxActiveVciBitsField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.atmInterfaceMaxActiveVciBitsField);
                jDMInput.setValue(object);
                this.validateatmInterfaceMaxActiveVciBitsField();
            }
        }

        protected boolean validateatmInterfaceMaxActiveVciBitsField() {
            JDMInput jDMInput = (JDMInput)((Object)this.atmInterfaceMaxActiveVciBitsField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.atmInterfaceMaxActiveVciBitsFieldLabel.setForeground(Color.yellow);
            } else {
                this.atmInterfaceMaxActiveVciBitsFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createatmInterfaceIlmiVpiField() {
            String string = AtmInterfacePanel.this.getOverride("ibm.nways.atm.model.AtmInterface.Panel.AtmInterfaceIlmiVpi.access", "read-write");
            this.atmInterfaceIlmiVpiFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.atmInterfaceIlmiVpiFieldLabel = new Label(AtmInterfacePanel.getNLSString("atmInterfaceIlmiVpiLabel"), 2);
            if (this.atmInterfaceIlmiVpiFieldWritable) {
                NumericInput numericInput = new NumericInput();
                numericInput.setMinMax(0, 255);
                this.addRow(this.atmInterfaceIlmiVpiFieldLabel, (Component)numericInput);
                AtmInterfacePanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.atmInterfaceIlmiVpiFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getatmInterfaceIlmiVpiField() {
            JDMInput jDMInput = (JDMInput)((Object)this.atmInterfaceIlmiVpiField);
            this.validateatmInterfaceIlmiVpiField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setatmInterfaceIlmiVpiField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.atmInterfaceIlmiVpiField);
                jDMInput.setValue(object);
                this.validateatmInterfaceIlmiVpiField();
            }
        }

        protected boolean validateatmInterfaceIlmiVpiField() {
            JDMInput jDMInput = (JDMInput)((Object)this.atmInterfaceIlmiVpiField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.atmInterfaceIlmiVpiFieldLabel.setForeground(Color.yellow);
            } else {
                this.atmInterfaceIlmiVpiFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createatmInterfaceIlmiVciField() {
            String string = AtmInterfacePanel.this.getOverride("ibm.nways.atm.model.AtmInterface.Panel.AtmInterfaceIlmiVci.access", "read-write");
            this.atmInterfaceIlmiVciFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.atmInterfaceIlmiVciFieldLabel = new Label(AtmInterfacePanel.getNLSString("atmInterfaceIlmiVciLabel"), 2);
            if (this.atmInterfaceIlmiVciFieldWritable) {
                NumericInput numericInput = new NumericInput();
                numericInput.setMinMax(0, 65535);
                this.addRow(this.atmInterfaceIlmiVciFieldLabel, (Component)numericInput);
                AtmInterfacePanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.atmInterfaceIlmiVciFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getatmInterfaceIlmiVciField() {
            JDMInput jDMInput = (JDMInput)((Object)this.atmInterfaceIlmiVciField);
            this.validateatmInterfaceIlmiVciField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setatmInterfaceIlmiVciField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.atmInterfaceIlmiVciField);
                jDMInput.setValue(object);
                this.validateatmInterfaceIlmiVciField();
            }
        }

        protected boolean validateatmInterfaceIlmiVciField() {
            JDMInput jDMInput = (JDMInput)((Object)this.atmInterfaceIlmiVciField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.atmInterfaceIlmiVciFieldLabel.setForeground(Color.yellow);
            } else {
                this.atmInterfaceIlmiVciFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createatmInterfaceAddressTypeField() {
            String string = AtmInterfacePanel.this.getOverride("ibm.nways.atm.model.AtmInterface.Panel.AtmInterfaceAddressType.access", "read-only");
            this.atmInterfaceAddressTypeFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.atmInterfaceAddressTypeFieldLabel = new Label(AtmInterfacePanel.getNLSString("atmInterfaceAddressTypeLabel"), 2);
            if (this.atmInterfaceAddressTypeFieldWritable) {
                SingleChoiceInput singleChoiceInput = new SingleChoiceInput(AtmInterfaceModel.Panel.AtmInterfaceAddressTypeEnum.symbolicValues, AtmInterfaceModel.Panel.AtmInterfaceAddressTypeEnum.numericValues, AtmInterfacePanel.getEnumStrings());
                this.addRow(this.atmInterfaceAddressTypeFieldLabel, (Component)singleChoiceInput);
                AtmInterfacePanel.this.containsWritableField = true;
                return singleChoiceInput;
            }
            SingleChoiceInputRO singleChoiceInputRO = new SingleChoiceInputRO(AtmInterfaceModel.Panel.AtmInterfaceAddressTypeEnum.symbolicValues, AtmInterfaceModel.Panel.AtmInterfaceAddressTypeEnum.numericValues, AtmInterfacePanel.getEnumStrings());
            this.addRow(this.atmInterfaceAddressTypeFieldLabel, (Component)singleChoiceInputRO);
            return singleChoiceInputRO;
        }

        protected Serializable getatmInterfaceAddressTypeField() {
            JDMInput jDMInput = (JDMInput)((Object)this.atmInterfaceAddressTypeField);
            this.validateatmInterfaceAddressTypeField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setatmInterfaceAddressTypeField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.atmInterfaceAddressTypeField);
                jDMInput.setValue(object);
                this.validateatmInterfaceAddressTypeField();
            }
        }

        protected boolean validateatmInterfaceAddressTypeField() {
            JDMInput jDMInput = (JDMInput)((Object)this.atmInterfaceAddressTypeField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.atmInterfaceAddressTypeFieldLabel.setForeground(Color.yellow);
            } else {
                this.atmInterfaceAddressTypeFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        public void layoutSection() {
            this.ifDescrField = this.createifDescrField();
            this.atmInterfaceMaxVpcsField = this.createatmInterfaceMaxVpcsField();
            this.atmInterfaceMaxVccsField = this.createatmInterfaceMaxVccsField();
            this.atmInterfaceConfVpcsField = this.createatmInterfaceConfVpcsField();
            this.atmInterfaceConfVccsField = this.createatmInterfaceConfVccsField();
            this.atmInterfaceMaxActiveVpiBitsField = this.createatmInterfaceMaxActiveVpiBitsField();
            this.atmInterfaceMaxActiveVciBitsField = this.createatmInterfaceMaxActiveVciBitsField();
            this.atmInterfaceIlmiVpiField = this.createatmInterfaceIlmiVpiField();
            this.atmInterfaceIlmiVciField = this.createatmInterfaceIlmiVciField();
            this.atmInterfaceAddressTypeField = this.createatmInterfaceAddressTypeField();
        }

        public void apply() {
            if (this.validateSection()) {
                if (!((JDMInput)((Object)this.ifDescrField)).ignoreValue() && this.ifDescrFieldWritable) {
                    AtmInterfacePanel.this.PanelInfo.add("Panel.IfDescr", this.getifDescrField());
                }
                if (!((JDMInput)((Object)this.atmInterfaceMaxVpcsField)).ignoreValue() && this.atmInterfaceMaxVpcsFieldWritable) {
                    AtmInterfacePanel.this.PanelInfo.add("Panel.AtmInterfaceMaxVpcs", this.getatmInterfaceMaxVpcsField());
                }
                if (!((JDMInput)((Object)this.atmInterfaceMaxVccsField)).ignoreValue() && this.atmInterfaceMaxVccsFieldWritable) {
                    AtmInterfacePanel.this.PanelInfo.add("Panel.AtmInterfaceMaxVccs", this.getatmInterfaceMaxVccsField());
                }
                if (!((JDMInput)((Object)this.atmInterfaceConfVpcsField)).ignoreValue() && this.atmInterfaceConfVpcsFieldWritable) {
                    AtmInterfacePanel.this.PanelInfo.add("Panel.AtmInterfaceConfVpcs", this.getatmInterfaceConfVpcsField());
                }
                if (!((JDMInput)((Object)this.atmInterfaceConfVccsField)).ignoreValue() && this.atmInterfaceConfVccsFieldWritable) {
                    AtmInterfacePanel.this.PanelInfo.add("Panel.AtmInterfaceConfVccs", this.getatmInterfaceConfVccsField());
                }
                if (!((JDMInput)((Object)this.atmInterfaceMaxActiveVpiBitsField)).ignoreValue() && this.atmInterfaceMaxActiveVpiBitsFieldWritable) {
                    AtmInterfacePanel.this.PanelInfo.add("Panel.AtmInterfaceMaxActiveVpiBits", this.getatmInterfaceMaxActiveVpiBitsField());
                }
                if (!((JDMInput)((Object)this.atmInterfaceMaxActiveVciBitsField)).ignoreValue() && this.atmInterfaceMaxActiveVciBitsFieldWritable) {
                    AtmInterfacePanel.this.PanelInfo.add("Panel.AtmInterfaceMaxActiveVciBits", this.getatmInterfaceMaxActiveVciBitsField());
                }
                if (!((JDMInput)((Object)this.atmInterfaceIlmiVpiField)).ignoreValue() && this.atmInterfaceIlmiVpiFieldWritable) {
                    AtmInterfacePanel.this.PanelInfo.add("Panel.AtmInterfaceIlmiVpi", this.getatmInterfaceIlmiVpiField());
                }
                if (!((JDMInput)((Object)this.atmInterfaceIlmiVciField)).ignoreValue() && this.atmInterfaceIlmiVciFieldWritable) {
                    AtmInterfacePanel.this.PanelInfo.add("Panel.AtmInterfaceIlmiVci", this.getatmInterfaceIlmiVciField());
                }
                if (!((JDMInput)((Object)this.atmInterfaceAddressTypeField)).ignoreValue() && this.atmInterfaceAddressTypeFieldWritable) {
                    AtmInterfacePanel.this.PanelInfo.add("Panel.AtmInterfaceAddressType", this.getatmInterfaceAddressTypeField());
                    return;
                }
            } else {
                AtmInterfacePanel.this.errorsFound = true;
            }
        }

        public void reset() {
            AtmInterfacePanel.this.displayMsg(AtmInterfacePanel.getNLSString("accessDataMsg"));
            try {
                this.setifDescrField(AtmInterfacePanel.this.AtmInterfaceConfTableData.getValueAt("Panel.IfDescr", AtmInterfacePanel.this.AtmInterfaceConfTableIndex));
                this.setatmInterfaceMaxVpcsField(AtmInterfacePanel.this.AtmInterfaceConfTableData.getValueAt("Panel.AtmInterfaceMaxVpcs", AtmInterfacePanel.this.AtmInterfaceConfTableIndex));
                this.setatmInterfaceMaxVccsField(AtmInterfacePanel.this.AtmInterfaceConfTableData.getValueAt("Panel.AtmInterfaceMaxVccs", AtmInterfacePanel.this.AtmInterfaceConfTableIndex));
                this.setatmInterfaceConfVpcsField(AtmInterfacePanel.this.AtmInterfaceConfTableData.getValueAt("Panel.AtmInterfaceConfVpcs", AtmInterfacePanel.this.AtmInterfaceConfTableIndex));
                this.setatmInterfaceConfVccsField(AtmInterfacePanel.this.AtmInterfaceConfTableData.getValueAt("Panel.AtmInterfaceConfVccs", AtmInterfacePanel.this.AtmInterfaceConfTableIndex));
                this.setatmInterfaceMaxActiveVpiBitsField(AtmInterfacePanel.this.AtmInterfaceConfTableData.getValueAt("Panel.AtmInterfaceMaxActiveVpiBits", AtmInterfacePanel.this.AtmInterfaceConfTableIndex));
                this.setatmInterfaceMaxActiveVciBitsField(AtmInterfacePanel.this.AtmInterfaceConfTableData.getValueAt("Panel.AtmInterfaceMaxActiveVciBits", AtmInterfacePanel.this.AtmInterfaceConfTableIndex));
                this.setatmInterfaceIlmiVpiField(AtmInterfacePanel.this.AtmInterfaceConfTableData.getValueAt("Panel.AtmInterfaceIlmiVpi", AtmInterfacePanel.this.AtmInterfaceConfTableIndex));
                this.setatmInterfaceIlmiVciField(AtmInterfacePanel.this.AtmInterfaceConfTableData.getValueAt("Panel.AtmInterfaceIlmiVci", AtmInterfacePanel.this.AtmInterfaceConfTableIndex));
                this.setatmInterfaceAddressTypeField(AtmInterfacePanel.this.AtmInterfaceConfTableData.getValueAt("Panel.AtmInterfaceAddressType", AtmInterfacePanel.this.AtmInterfaceConfTableIndex));
            }
            catch (NullPointerException nullPointerException) {}
            AtmInterfacePanel.this.errorsFound = !this.validateSection();
            this.doLayout();
        }

        protected void rowChange() {
            this.setifDescrField(AtmInterfacePanel.this.AtmInterfaceConfTableData.getValueAt("Panel.IfDescr", AtmInterfacePanel.this.AtmInterfaceConfTableIndex));
            this.setatmInterfaceMaxVpcsField(AtmInterfacePanel.this.AtmInterfaceConfTableData.getValueAt("Panel.AtmInterfaceMaxVpcs", AtmInterfacePanel.this.AtmInterfaceConfTableIndex));
            this.setatmInterfaceMaxVccsField(AtmInterfacePanel.this.AtmInterfaceConfTableData.getValueAt("Panel.AtmInterfaceMaxVccs", AtmInterfacePanel.this.AtmInterfaceConfTableIndex));
            this.setatmInterfaceConfVpcsField(AtmInterfacePanel.this.AtmInterfaceConfTableData.getValueAt("Panel.AtmInterfaceConfVpcs", AtmInterfacePanel.this.AtmInterfaceConfTableIndex));
            this.setatmInterfaceConfVccsField(AtmInterfacePanel.this.AtmInterfaceConfTableData.getValueAt("Panel.AtmInterfaceConfVccs", AtmInterfacePanel.this.AtmInterfaceConfTableIndex));
            this.setatmInterfaceMaxActiveVpiBitsField(AtmInterfacePanel.this.AtmInterfaceConfTableData.getValueAt("Panel.AtmInterfaceMaxActiveVpiBits", AtmInterfacePanel.this.AtmInterfaceConfTableIndex));
            this.setatmInterfaceMaxActiveVciBitsField(AtmInterfacePanel.this.AtmInterfaceConfTableData.getValueAt("Panel.AtmInterfaceMaxActiveVciBits", AtmInterfacePanel.this.AtmInterfaceConfTableIndex));
            this.setatmInterfaceIlmiVpiField(AtmInterfacePanel.this.AtmInterfaceConfTableData.getValueAt("Panel.AtmInterfaceIlmiVpi", AtmInterfacePanel.this.AtmInterfaceConfTableIndex));
            this.setatmInterfaceIlmiVciField(AtmInterfacePanel.this.AtmInterfaceConfTableData.getValueAt("Panel.AtmInterfaceIlmiVci", AtmInterfacePanel.this.AtmInterfaceConfTableIndex));
            this.setatmInterfaceAddressTypeField(AtmInterfacePanel.this.AtmInterfaceConfTableData.getValueAt("Panel.AtmInterfaceAddressType", AtmInterfacePanel.this.AtmInterfaceConfTableIndex));
            this.doLayout();
        }

        public boolean validateSection() {
            if (!((JDMInput)((Object)this.atmInterfaceMaxActiveVciBitsField)).ignoreValue() && !this.validateatmInterfaceMaxActiveVciBitsField()) {
                return false;
            }
            if (!((JDMInput)((Object)this.atmInterfaceMaxActiveVpiBitsField)).ignoreValue() && !this.validateatmInterfaceMaxActiveVpiBitsField()) {
                return false;
            }
            if (!((JDMInput)((Object)this.atmInterfaceMaxVpcsField)).ignoreValue() && !this.validateatmInterfaceMaxVpcsField()) {
                return false;
            }
            if (!((JDMInput)((Object)this.atmInterfaceMaxVccsField)).ignoreValue() && !this.validateatmInterfaceMaxVccsField()) {
                return false;
            }
            if (!((JDMInput)((Object)this.atmInterfaceIlmiVciField)).ignoreValue() && !this.validateatmInterfaceIlmiVciField()) {
                return false;
            }
            return ((JDMInput)((Object)this.atmInterfaceIlmiVpiField)).ignoreValue() || this.validateatmInterfaceIlmiVpiField();
        }
    }

    public class AtmInterfaceConfTable
    extends Table {
        public ModelInfo setRow() {
            try {
                AtmInterfacePanel.this.displayMsg(AtmInterfacePanel.getNLSString("startSendMsg"));
                AtmInterfacePanel.this.PanelInfo = AtmInterfacePanel.this.AtmInterface_model.setInfo("Panel", AtmInterfacePanel.this.PanelInfo);
                AtmInterfacePanel.this.displayMsg(AtmInterfacePanel.getNLSString("endSendMsg"));
                if (AtmInterfacePanel.this.PanelInfo != null) {
                    Enumeration enumeration = AtmInterfacePanel.this.PanelInfo.getItemIds();
                    while (enumeration.hasMoreElements()) {
                        String string = (String)enumeration.nextElement();
                        Serializable serializable = AtmInterfacePanel.this.PanelInfo.get(string);
                        AtmInterfacePanel.this.AtmInterfaceConfTableInfo.add(string, serializable);
                    }
                }
            }
            catch (RemoteException remoteException) {
                System.out.println(remoteException);
                remoteException.printStackTrace();
            }
            return AtmInterfacePanel.this.AtmInterfaceConfTableInfo;
        }

        public ModelInfo getRow(ModelInfo modelInfo) {
            try {
                while (true) {
                    AtmInterfacePanel.this.AtmInterfaceConfTableInfo = null;
                    AtmInterfacePanel.this.displayMsg(AtmInterfacePanel.getNLSString("startRow"));
                    AtmInterfacePanel.this.PanelInfo = AtmInterfacePanel.this.AtmInterface_model.getNextInfo("Panel", "default", modelInfo);
                    AtmInterfacePanel.this.displayMsg(AtmInterfacePanel.getNLSString("endRow"));
                    if (AtmInterfacePanel.this.PanelInfo != null) {
                        AtmInterfacePanel.this.AtmInterfaceConfTableInfo = new ModelInfo();
                        if (AtmInterfacePanel.this.PanelInfo.isBeingMonitored()) {
                            AtmInterfacePanel.this.AtmInterfaceConfTableInfo.flagAsMonitored();
                        }
                        Enumeration enumeration = AtmInterfacePanel.this.PanelInfo.getItemIds();
                        while (enumeration.hasMoreElements()) {
                            String string = (String)enumeration.nextElement();
                            Serializable serializable = AtmInterfacePanel.this.PanelInfo.get(string);
                            AtmInterfacePanel.this.AtmInterfaceConfTableInfo.add(string, serializable);
                        }
                    }
                    if (AtmInterfacePanel.this.AtmInterfaceConfTableInfo != null && !this.validRow(AtmInterfacePanel.this.AtmInterfaceConfTableInfo)) {
                        modelInfo = AtmInterfacePanel.this.AtmInterfaceConfTableInfo;
                        continue;
                    }
                    break;
                }
            }
            catch (RemoteException remoteException) {
                System.out.println(remoteException);
                remoteException.printStackTrace();
            }
            return AtmInterfacePanel.this.AtmInterfaceConfTableInfo;
        }

        public ModelInfo getSpecificRow(ModelInfo modelInfo) {
            AtmInterfacePanel.this.AtmInterfaceConfTableInfo = null;
            try {
                AtmInterfacePanel.this.displayMsg(AtmInterfacePanel.getNLSString("startRow"));
                AtmInterfacePanel.this.PanelInfo = AtmInterfacePanel.this.AtmInterface_model.getInfo("Panel", "default", modelInfo);
                AtmInterfacePanel.this.displayMsg(AtmInterfacePanel.getNLSString("endRow"));
                if (AtmInterfacePanel.this.PanelInfo != null) {
                    AtmInterfacePanel.this.AtmInterfaceConfTableInfo = new ModelInfo();
                    if (AtmInterfacePanel.this.PanelInfo.isBeingMonitored()) {
                        AtmInterfacePanel.this.AtmInterfaceConfTableInfo.flagAsMonitored();
                    }
                    Enumeration enumeration = AtmInterfacePanel.this.PanelInfo.getItemIds();
                    while (enumeration.hasMoreElements()) {
                        String string = (String)enumeration.nextElement();
                        Serializable serializable = AtmInterfacePanel.this.PanelInfo.get(string);
                        AtmInterfacePanel.this.AtmInterfaceConfTableInfo.add(string, serializable);
                    }
                }
                if (AtmInterfacePanel.this.AtmInterfaceConfTableInfo != null && !this.validRow(AtmInterfacePanel.this.AtmInterfaceConfTableInfo)) {
                    AtmInterfacePanel.this.AtmInterfaceConfTableInfo = this.getRow(AtmInterfacePanel.this.AtmInterfaceConfTableInfo);
                }
            }
            catch (RemoteException remoteException) {
                System.out.println(remoteException);
                remoteException.printStackTrace();
            }
            return AtmInterfacePanel.this.AtmInterfaceConfTableInfo;
        }

        public boolean validRow(ModelInfo modelInfo) {
            return true;
        }

        public void setMonitoring(ModelInfo[] modelInfoArray, boolean bl) {
            try {
                if (AtmInterfacePanel.this.AtmInterfaceConfTableStatus != null) {
                    if (modelInfoArray != null) {
                        if (bl) {
                            AtmInterfacePanel.this.AtmInterfaceConfTableStatus.monitor(modelInfoArray);
                            return;
                        }
                        AtmInterfacePanel.this.AtmInterfaceConfTableStatus.doNotMonitor(modelInfoArray);
                        return;
                    }
                    if (bl) {
                        AtmInterfacePanel.this.AtmInterfaceConfTableStatus.setMaxRows(Integer.MAX_VALUE);
                        return;
                    }
                    AtmInterfacePanel.this.AtmInterfaceConfTableStatus.setMaxRows(0);
                    return;
                }
            }
            catch (RemoteException remoteException) {
                System.out.println(remoteException);
                remoteException.printStackTrace();
            }
        }

        public String translateEnum(String string, int n) {
            String string2 = String.valueOf(n);
            return string2;
        }

        public AtmInterfaceConfTable() {
            AtmInterfacePanel.this = AtmInterfacePanel.this;
        }
    }
}

